namespace win
	#include "windows.bi"
end namespace
using win
#include "resource.bi"

declare function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"

dim shared as win.HBRUSH g_hbrBackground = NULL

function DlgProc( _
	byval hwnd as win.HWND, _
	byval msg as win.UINT, _
	byval wParam as win.WPARAM, _
	byval lParam as win.LPARAM) as win.BOOL
	
	select case msg
		case WM_INITDIALOG
			g_hbrBackground = win.CreateSolidBrush(RGB(0, 0, 0))

			win.SendMessage(hwnd, WM_SETICON, ICON_SMALL, cast(win.LPARAM, LoadIcon(NULL, _ 
				MAKEINTRESOURCE(IDD_MAIN))))
			win.SendMessage(hwnd, WM_SETICON, ICON_BIG, cast( win.LPARAM, LoadIcon(NULL, _
				MAKEINTRESOURCE(IDD_MAIN))))
		case WM_CLOSE
			win.EndDialog(hwnd, 0)
		case WM_CTLCOLORDLG
			return cast(LONG, g_hbrBackground)
		case WM_CTLCOLORSTATIC
		scope
			dim as win.HDC hdcStatic = cast( win.HDC, wParam )
			win.SetTextColor(hdcStatic, RGB(255, 255, 255))
			win.SetBkMode(hdcStatic, TRANSPARENT)
			return cast(LONG, g_hbrBackground)
		end scope
		case WM_COMMAND
			select case LOWORD(wParam)
				case IDOK
					win.EndDialog(hwnd, 0)
			end select
		case WM_DESTROY
			win.DeleteObject(g_hbrBackground)
		case else
			return FALSE
	end select
	return TRUE
end function

function WinMain ( _
	byval hInstance as hInstance, _
	byval hPrevInstance as hInstance, _
	byval lpCmdLine as LPSTR, _
	byval nCmdShow as integer ) as integer
	
	return win.DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, @DlgProc())
end function
